//
//  LocationViewController.m
//  Location
//
//  Created by Jonathan Diehl on 30.05.11.
//  Copyright 2011 RWTH. All rights reserved.
//

#import "LocationViewController.h"

@implementation LocationViewController

@synthesize locationLabel, headingLabel;


#pragma mark CLLocationManagerDelegate

// change location
- (void)locationManager:(CLLocationManager *)manager didUpdateToLocation:(CLLocation *)newLocation fromLocation:(CLLocation *)oldLocation;
{
	CLLocationCoordinate2D coord = newLocation.coordinate;
	locationLabel.text = [NSString stringWithFormat:@"Lat:%.4f Lon:%.4f, Alt: %.1f", coord.latitude, coord.longitude, newLocation.altitude];
}

// changed heading
- (void)locationManager:(CLLocationManager *)manager didUpdateHeading:(CLHeading *)newHeading
{
	headingLabel.text = [NSString stringWithFormat:@"Mag:%.1f True:%.1f", newHeading.magneticHeading, newHeading.trueHeading];
}


#pragma mark UIViewController

// init view
- (void)viewDidLoad;
{
    [super viewDidLoad];
	
	// load the location manager
	manager = [[CLLocationManager alloc] init];
	manager.delegate = self;
}

// view did appear
- (void)viewDidAppear:(BOOL)animated;
{
	// start location and heading updates
	[manager startUpdatingLocation];
	[manager startUpdatingHeading];
}

// view will disappear
- (void)viewWillDisappear:(BOOL)animated;
{
	// stop location and heading updates
	[manager stopUpdatingHeading];
	[manager stopUpdatingLocation];
}

// clean up
- (void)dealloc
{
	[manager release];
    [super dealloc];
}


@end
